﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace HIPS.CommonSchemas.Cda
{
    /// <summary>
    /// Store all of the Test Result Name data that is common across both the Pathology and Diagnostic Imaging. 
    /// </summary>
    public class TestResultName
    {
        /// <summary>
        /// The Test Result Code.
        /// </summary>
        public string Code { get; set; }
        
        /// <summary>
        /// The Test Result Name.
        /// </summary>
        public string Name { get; set; }
        
        /// <summary>
        /// The Test Result Code System.
        /// </summary>
        public string CodeSystem { get; set; }
        
        /// <summary>
        /// The HL7® field that provided the data.
        /// </summary>
        public string HL7Field { get; set; }
    }
}
