﻿// -----------------------------------------------------------------------
// <copyright file="Participant.cs"  company="NEHTA">
// Developed by Chamonix for NEHTA.
// </copyright>
// -----------------------------------------------------------------------

using HIPS.CommonSchemas.Cda;
using System.Collections.Generic;
using System.Runtime.Serialization;

namespace HIPS.CommonSchemas
{
    /// <summary>
    /// Represents a person who participated in the document creation process.
    /// Typically the "sender", "author" or the "legalAuthenticator".
    /// The Approver of the CDA Signature will be generated from this object.
    /// </summary>
    [DataContract]
    public class Participant
    {
        /// <summary>
        /// The CDA document can have more than one ID for each person.
        /// Only the first ID will be used in the CDA signature.
        /// </summary>
        [DataMember]
        public List<EntityIdentifier> Identifiers { get; set; }

        /// <summary>
        /// The person's family name.
        /// </summary>
        [DataMember]
        public string FamilyName { get; set; }

        /// <summary>
        /// The person's given names.
        /// </summary>
        [DataMember]
        public List<string> GivenNames { get; set; }

        /// <summary>
        /// The person's name suffixes (like "Jr")
        /// </summary>
        [DataMember]
        public List<string> Suffixes { get; set; }

        /// <summary>
        /// The person's titles (like "Dr", "Ms" or "Mr")
        /// </summary>
        [DataMember]
        public List<string> Titles { get; set; }

        /// <summary>
        /// Initialises a new instance of the <see cref="Participant"/> class.
        /// </summary>
        public Participant()
        {
            this.GivenNames = new List<string>();
            this.Titles = new List<string>();
            this.Suffixes = new List<string>();
            this.Identifiers = new List<EntityIdentifier>();
        }
    }
}