﻿using System;

namespace HIPS.HibIntegration.Loader
{
    /// <summary>
    /// This exception is thrown when the IHI lookup fails for a reason
    /// unrelated to data quality, such as when the Medicare service is
    /// temporarily unavailable. The application support team should see
    /// the message, so an "ERROR" message is written to the log.
    ///
    /// The HL7 message broker should skip to the next message. Therefore a
    /// successful "AA" HL7 acknowledgement will be returned.
    /// </summary>
    public class IhiErrorException : Exception
    {
        public IhiErrorException(string textMessage)
            : base(textMessage)
        {
        }
    }
}