﻿using System;
using JetBrains.Annotations;

namespace HIPS.HpiiSchemas.Attributes
{
    /// <summary>
    /// This attribute is applied to enumeration members to declare the code and description associated with each member.
    /// </summary>
    [AttributeUsage(AttributeTargets.Field)]
    public class CodeAttribute : Attribute
    {
        /// <summary>
        /// The Code (typically a CDA code)
        /// </summary>
        [CanBeNull]
        public String Code { get; set; }

        /// <summary>
        /// The free text Description
        /// </summary>
        [CanBeNull]
        public String Description { get; set; }
    }
}