﻿using System;
using System.Runtime.Serialization;
using HIPS.CommonSchemas;
using HIPS.HpiiSchemas.Enumerators;
using nehta.mcaR50.ProviderSearchForProviderIndividual;

namespace HIPS.HpiiSchemas
{
    /// <summary>
    /// This class is used for returning a single response from the HPII service
    /// </summary>

    [KnownType(typeof(HpiiQueryResponse))]
    [Serializable]
    [DataContract]
    public class HpiiQueryResponse : HpiiQuery
    {
        #region Private Members

        private AustralianAddress australianAddress;
        private HipsResponse hipsResponse = new HipsResponse(HipsResponseIndicator.SystemError, null);
        private string hpiiNumber;
        private HpiiStatus hpiiStatus = HpiiStatus.Undefined;
        private InternationalAddress internationalAddress;
        private string postCode;
        private string registrationId;
        private ServiceMessagesType serviceMessagesType;
        private StateType? state;

        #endregion Private Members

        #region Properties

        /// <summary>
        /// Gets or sets the AustralianAddress
        /// </summary>
        /// <value>
        /// The australianAddress
        /// </value>
        [DataMember]
        public AustralianAddress AustralianAddress
        {
            get { return australianAddress; }
            set { australianAddress = value; }
        }

        /// <summary>
        /// Gets or sets the ServiceMessagesType
        /// </summary>
        /// <value>
        /// The serviceMessagesType
        /// </value>
        [DataMember]
        public HipsResponse HipsResponse
        {
            get { return hipsResponse; }
            set { hipsResponse = value; }
        }

        /// <summary>
        /// Gets or sets the HpiiNumber
        /// </summary>
        /// <value>
        /// The hpiiNumber
        /// </value>
        [DataMember]
        public string HpiiNumber
        {
            get { return hpiiNumber; }
            set { hpiiNumber = value; }
        }

        /// <summary>
        /// Gets or sets the HpiiStatus
        /// </summary>
        /// <value>
        /// The hpiiStatus
        /// </value>
        [DataMember]
        public HpiiStatus HpiiStatus
        {
            get { return hpiiStatus; }
            set { hpiiStatus = value; }
        }

        /// <summary>
        /// Gets or sets the InternationalAddress
        /// </summary>
        /// <value>
        /// The internationalAddress
        /// </value>
        [DataMember]
        public InternationalAddress InternationalAddress
        {
            get { return internationalAddress; }
            set { internationalAddress = value; }
        }

        /// <summary>
        /// Gets or sets the PostCode
        /// </summary>
        /// <value>
        /// The postCode
        /// </value>
        [DataMember]
        public string PostCode
        {
            get { return postCode; }
            set { postCode = value; }
        }

        /// <summary>
        /// Gets or sets the RegistrationId
        /// </summary>
        /// <value>
        /// The registrationId
        /// </value>
        [DataMember]
        public string RegistrationId
        {
            get { return registrationId; }
            set { registrationId = value; }
        }

        /// <summary>
        /// Gets or sets the ServiceMessagesType
        /// </summary>
        /// <value>
        /// The serviceMessagesType
        /// </value>
        [DataMember]
        public ServiceMessagesType ServiceMessagesType
        {
            get { return serviceMessagesType; }
            set { serviceMessagesType = value; }
        }

        /// <summary>
        /// Gets or sets the State
        /// </summary>
        /// <value>
        /// The state
        /// </value>
        [DataMember]
        public StateType? State
        {
            get { return state; }
            set { state = value; }
        }

        #endregion Properties
    }
}