﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using HIPS.Common.DataStore.DataAccess;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.CommonSchemas;
using HIPS.PcehrDataStore.Schemas;
using HIPS.PcehrDataStore.Schemas.Enumerators;


namespace HIPS.PcehrDataStore.DataAccess
{
    /// <summary>
    /// This class allows access to the HealthProviderIndividualHpii table
    /// </summary>
    public class HealthProviderIndividualHpiiDl : BaseDl
    {
        #region Constructors

        /// <summary>
        /// Creates a data access object for the health provider individual hpii.
        /// </summary>
        /// <param name="user">The person responsible for the action.</param>
        public HealthProviderIndividualHpiiDl(UserDetails user)
        {
            this.User = user;
        }

        #endregion Constructors

        #region Methods

        public HealthProviderIndividualHpii Get(int healthProviderIndividualId, int healthProviderOrganisationNetworkId)
        {
            var result = new HealthProviderIndividualHpii();

            try
            {
                using (var command = GetSqlCommand("hips.HealthProviderIndividualHpiiGet"))
                {
                    command.Parameters.Add(new SqlParameter("@HealthProviderIndividualId", healthProviderIndividualId));
                    command.Parameters.Add(new SqlParameter("@HealthProviderOrganisationNetworkId", healthProviderOrganisationNetworkId));

                    if (!PopulateBusinessObject<HealthProviderIndividualHpii>(command.ExecuteReader(), result))
                    {
                        result = null;
                    }

                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                string message = string.Format(ConstantsResource.ErrorMessageHealthProviderIndividualHpiiGet, healthProviderIndividualId);
                EventLogger.WriteLog(message, ex, User, LogMessage.HIPS_MESSAGE_184);
            }

            return result;
        }

        public HealthProviderIndividualHpii Get(string hpii, int healthProviderOrganisationNetworkId)
        {
            var result = new HealthProviderIndividualHpii();

            try
            {
                using (SqlCommand command = GetSqlCommand("hips.HealthProviderIndividualHpiiGet"))
                {
                    command.Parameters.Add(new SqlParameter("@Hpii", hpii));
                    command.Parameters.Add(new SqlParameter("@HealthProviderOrganisationNetworkId", healthProviderOrganisationNetworkId));

                    if (!PopulateBusinessObject<HealthProviderIndividualHpii>(command.ExecuteReader(), result))
                    {
                        result = null;
                    }
                    
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                string message = string.Format(ConstantsResource.ErrorMessageHealthProviderIndividualHpiiGet, hpii);
                EventLogger.WriteLog(message, ex, User, LogMessage.HIPS_MESSAGE_184);
            }

            return result;
        }

        public bool Insert(HealthProviderIndividualHpii item, SqlTransaction transaction)
        {
            using (var command = GetSqlCommand("hips.HealthProviderIndividualHpiiInsert", transaction))
            {
                return base.Insert<HealthProviderIndividualHpii>(item, command);
            }
        }

        public bool Delete(HealthProviderIndividualHpii item, SqlTransaction transaction)
        {
            using (var command = GetSqlCommand("hips.HealthProviderIndividualHpiiDelete", transaction))
            {
                return base.Delete<HealthProviderIndividualHpii>(item, command);
            }
        }

        #endregion     
    }
}
