﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using HIPS.Common.DataStore.DataAccess;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.CommonSchemas;
using HIPS.PcehrDataStore.Schemas;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.DataAccess
{
    /// <summary>
    /// This class allows access to the PendingIhiPcehrLookup table.
    /// </summary>
    public class PendingIhiPcehrLookupDl : BaseDl
    {
        #region Constructors

        public PendingIhiPcehrLookupDl(UserDetails user)
            : base(user)
        {
        }

        #endregion Constructors

        #region Methods

        /// <summary>
        /// Deletes the pending IHI/PCEHR lookup for the specified patient master and hospital.
        /// </summary>
        /// <param name="item">The item.</param>
        /// <returns></returns>
        public bool Delete(PendingIhiPcehrLookup item)
        {
            using (SqlCommand command = GetSqlCommand("hips.PendingIhiPcehrLookupDelete"))
            {
                return base.Delete<PendingIhiPcehrLookup>(item, command);
            }
        }

        /// <summary>
        /// Gets all PendingIhiPcehrLookup records.
        /// </summary>
        /// <returns>List of PendingIhiPcehrLookup records</returns>
        public List<PendingIhiPcehrLookup> GetAll()
        {
            List<PendingIhiPcehrLookup> results = new List<PendingIhiPcehrLookup>();
            try
            {
                using (SqlCommand command = GetSqlCommand("hips.PendingIhiPcehrLookupGet"))
                {
                    results = GetPopulatedBusinessList<PendingIhiPcehrLookup>(command.ExecuteReader());
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                string message = string.Format(ConstantsResource.ErrorMessagePendingIhiPcehrLookupGetAll);
                EventLogger.WriteLog(message, ex, User, LogMessage.HIPS_MESSAGE_171);
            }
            return results;
        }

        /// <summary>
        /// Saves a pending IHI/PCEHR lookup for the specified patient master and hospital.
        /// This will update the UserModified/DateModified if it exists, otherwise create it.
        /// </summary>
        /// <param name="item">The item.</param>
        /// <returns>Whether successful.</returns>
        public bool Save(PatientMaster patientMaster, Hospital hospital)
        {
            var item = new PendingIhiPcehrLookup
            {
                PatientMasterId = patientMaster.PatientMasterId,
                HealthProviderOrganisationId = hospital.HealthProviderOrganisationId,
                DateCreated = DateTime.Now,
                DateModified = DateTime.Now
            };
            using (SqlCommand command = GetSqlCommand("hips.PendingIhiPcehrLookupSave"))
            {
                base.Update<PendingIhiPcehrLookup>(item, command);
            }
            return true;
        }

        #endregion Methods
    }
}