﻿using System;
using System.Runtime.Serialization;
using HIPS.Base.Schemas;
using BaseEnumerators = HIPS.Base.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents the type of address
    /// </summary>
    [KnownType(typeof(AddressType))]
    [Serializable]
    [DataContract]
    public class AddressType : BaseCodeListSchema
    {
        #region Properties

        /// <summary>
        /// Gets or sets the address type id.
        /// </summary>
        /// <value>
        /// The address id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.AutoGeneratedKey)]
        public int? AddressTypeId
        {
            get
            {
                return base.Id;
            }
            set
            {
                base.Id = value;
            }
        }

        #endregion Properties
    }
}