﻿using System;

using HIPS.Base.Schemas;
using HIPS.Base.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// CdaDocumentNumber schema.
    /// </summary>
    public class CdaDocumentNumber : BaseSchema
    {
        /// <summary>
        /// Gets or sets the CDA document number ID.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.AutoGeneratedKey)]
        public int? CdaDocumentNumberId
        {
            get
            {
                return base.Id;
            }

            set
            {
                base.Id = value;
            }
        }

        /// <summary>
        /// Gets or sets the CDA set number ID.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.Data)]
        public int CdaSetNumberId { get; set; }

        /// <summary>
        /// Gets or sets the document creation date/time.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.Data)]
        public DateTime DocumentCreationDateTime { get; set; }
    }
}