﻿using System;
using System.Runtime.Serialization;
using HIPS.Base.Schemas;
using BaseEnumerators = HIPS.Base.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents a health provider individual working within a single hospital
    /// </summary>
    [KnownType(typeof(HospitalHealthProviderIndividual))]
    [Serializable]
    [DataContract]
    public class HospitalHealthProviderIndividual : BaseSchema
    {
        #region Properties

        /// <summary>
        /// Gets or sets the Identifier of this provider allocated by the hospital's Clinical Information System (CIS).
        /// </summary>
        /// <value>
        /// The CIS provider identifier.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string CisProviderIdentifier { get; set; }

        /// <summary>
        /// Gets or sets the health provider individual id.
        /// </summary>
        /// <value>
        /// The health provider individual id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ApplicationGeneratedKey)]
        public int? HealthProviderIndividualId { get; set; }

        /// <summary>
        /// Gets or sets the hospital id.
        /// </summary>
        /// <value>
        /// The hospital id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ApplicationGeneratedKey)]
        public int? HospitalId { get; set; }

        /// <summary>
        /// Gets or sets the Identifier of this provider allocated by the hospital's Patient Administration System (PAS).
        /// </summary>
        /// <value>
        /// The PAS provider identifier.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string PasProviderIdentifier { get; set; }

        /// <summary>
        /// Gets or sets the Local Provider Code.
        /// </summary>
        /// <value>
        /// The Local Provider Code.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ReadOnlyData)]
        public string LocalProviderCode { get; set; }

        /// <summary>
        /// Gets or sets the Hospital Code.
        /// </summary>
        /// <value>
        /// The Hospital Code.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ReadOnlyData)]
        public string HospitalCode { get; set; }

        /// <summary>
        /// Gets or sets the Hospital Code System.
        /// </summary>
        /// <value>
        /// The Hospital Code System.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ReadOnlyData)]
        public string HospitalCodeSystem { get; set; }  

        #endregion Properties
    }
}