﻿using System;
using System.Runtime.Serialization;
using HIPS.CommonSchemas;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace HIPS.PcehrSchemas
{
    /// <summary>
    /// This class holds the returned response when a check to see if the PCEHR exists.
    /// </summary>
    [KnownType(typeof(CheckPcehrExistsResponse))]
    [Serializable]
    [DataContract]
    public class CheckPcehrExistsResponse
    {
        #region Private Members

        private HipsResponse hipsResponse = new HipsResponse(HipsResponseIndicator.SystemError);
        private bool? pcehrAdvertised = false;
        private bool? pcehrDisclosed = false;
        private bool? pcehrExists = false;

        #endregion Private Members

        #region Properties

        /// <summary>
        /// Gets or sets the HIPS response, including indicator of success or failure and information about any failures.
        /// </summary>
        /// <value>
        /// The HIPS response.
        /// </value>
        [DataMember]
        public HipsResponse HipsResponse
        {
            get
            {
                return hipsResponse;
            }
            set
            {
                hipsResponse = value;
            }
        }

        /// <summary>
        /// Gets or sets the does pcehr advertised flag.
        /// </summary>
        /// <value>
        /// The pcehr advertised.
        /// </value>
        [DataMember]
        public bool? PCEHRAdvertised 
        {
            get
            {
                return pcehrAdvertised;
            }
            set
            {
                pcehrAdvertised = value;
            }
        }

        /// <summary>
        /// Gets or sets the does pcehr disclosed flag.
        /// </summary>
        /// <value>
        /// The pcehr disclosed.
        /// </value>
        [DataMember]
        public bool? PcehrDisclosed 
        {
            get
            {
                return pcehrDisclosed;
            }
            set
            {
                pcehrDisclosed = value;
            }
        }

        
        /// <summary>
        /// Gets or sets the does pcehr exists flag.
        /// </summary>
        /// <value>
        /// The pcehr exists.
        /// </value>
        [DataMember]
        public bool? PcehrExists 
        {
            get
            {
                return pcehrExists;
            }
            set
            {
                pcehrExists = value;
            }
        }


        #endregion Properties
    }
}
