﻿using System.Collections.Generic;
using HIPS.CommonSchemas;
using HIPS.PcehrDataStore.Schemas;

namespace HIPS.PcehrSchemas
{
    /// <summary>
    /// This class represents the result of an operation status query.
    /// </summary>
    public class OperationStatus
    {
        private List<PcehrMessageQueue> queuedOperations = new List<PcehrMessageQueue>();
        private HipsResponse response = new HipsResponse(HipsResponseIndicator.OK);
        private List<ClinicalDocument> uploadedDocuments = new List<ClinicalDocument>();
        private List<ClinicalDocumentVersion> uploadedDocumentVersions = new List<ClinicalDocumentVersion>();

        /// <summary>
        /// Gets or sets a list of pending and failed queue operations.
        /// If the upload or remove request is not yet started or still in progress, it will be in this list with status of pending.
        /// If the upload or remove request failed, it will be in this list with a status of failed.
        /// By default, all successful uploads are removed from the queued list and thus not displayed.
        /// </summary>
        public List<PcehrMessageQueue> QueuedOperations
        {
            get
            {
                return queuedOperations;
            }
            set
            {
                queuedOperations = value;
            }
        }

        /// <summary>
        /// Gets or sets an indicator of success or failure of this request and the reason for failure.
        /// </summary>
        public HipsResponse Response
        {
            get
            {
                return response;
            }
            set
            {
                response = value;
            }
        }

        /// <summary>
        /// Gets or sets a list of uploaded clinical documents. If the upload or remove request
        /// succeeded, the document will be in this list and the document status
        /// will show Uploaded or Removed as appropriate.
        /// </summary>
        public List<ClinicalDocument> UploadedDocuments
        {
            get
            {
                return uploadedDocuments;
            }
            set
            {
                uploadedDocuments = value;
            }
        }

        /// <summary>
        /// Gets or sets a list of individual versions of uploaded clinical documents.
        /// This list contains the complete package contents of each
        /// version uploaded, and the date and time when it was uploaded.
        /// </summary>
        public List<ClinicalDocumentVersion> UploadedDocumentVersions
        {
            get
            {
                return uploadedDocumentVersions;
            }
            set
            {
                uploadedDocumentVersions = value;
            }
        }
    }
}