﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using HIPS.PcehrDataStore.Schemas;
using HIPS.CommonSchemas;
using System.Runtime.Serialization;

namespace HIPS.PcehrSchemas
{
    /// <summary>
    /// Queued HL7 Report Operation
    /// </summary>
    [KnownType(typeof(QueuedHL7ReportOperation))]
    [Serializable]
    [DataContract]
    public class QueuedHL7ReportOperation
    {
        #region Private members

        private byte[] pdfReport;
        private string hl7Message;
        private PcehrMessageQueue pendingItem;
        private int hl7MessageLogId;
        private UserDetails user;
        private string documentFormatCode;

        #endregion Private members

        #region properties
        /// <summary>
        /// The HL7® message.
        /// </summary>
        [DataMember]
        public string HL7Message 
        {   
            get
            {
                return this.hl7Message;
            }
            set
            {
                this.hl7Message = value;
            } 
        }
        
        /// <summary>
        /// The report as a base 64 byte array.
        /// </summary>
        [DataMember]
        public byte[] Report
        {
            get
            {
                return this.pdfReport;
            }
            set
            {
                this.pdfReport = value;
            }
        }
        
        /// <summary>
        /// The item to be stored on the queue.
        /// </summary>
        [DataMember]
        public PcehrMessageQueue PendingItem 
        {
            get
            {
                return this.pendingItem;
            }
            set
            {
                this.pendingItem = value;
            }
        }

        /// <summary>
        /// Gets or sets User.
        /// </summary>
        [DataMember]
        public UserDetails User 
        {
            get
            {
                return this.user;
            }
            set
            {
                this.user = value;
            }
        }

        /// <summary>
        /// Gets or sets the HL7 Message Log ID of the original HL7 message.
        /// </summary>
        [DataMember]
        public int HL7MessageLogId
        {
            get
            {
                return this.hl7MessageLogId;
            }
            set
            {
                this.hl7MessageLogId = value;
            }
        }

        /// <summary>
        /// Gets or sets the Document Format Code the HL7Report is.
        /// </summary>
        [DataMember]
        public string DocumentFormatCode
        {
            get
            {
                return this.documentFormatCode;
            }
            set
            {
                this.documentFormatCode = value;
            }
        }

        #endregion properties

        #region constructor

        /// <summary>
        /// Initializes a new instance of the <see cref="QueuedUploadOperation" /> class.
        /// </summary>
        /// <param name="user">The user.</param>
        public QueuedHL7ReportOperation(UserDetails user)
        {
            this.user = user;
        }

        #endregion constructor
    }
}
