﻿using System.Collections.Generic;
using HIPS.CommonSchemas;

namespace HIPS.PcehrSchemas
{
    /// <summary>
    /// The result of an Get Queued Operation List query.
    /// </summary>
    public class QueuedOperationStatus
    {
        private IList<MessageQueueItem> queuedOperations = new List<MessageQueueItem>();
        private HipsResponse response = new HipsResponse(HipsResponseIndicator.OK);

        /// <summary>
        /// Gets or sets the list of queued operations
        /// </summary>
        /// <value>
        /// The queued operation.
        /// </value>
        public IList<MessageQueueItem> QueuedOperations
        {
            get
            {
                return queuedOperations;
            }
            set
            {
                queuedOperations = value;
            }
        }

        /// <summary>
        /// Gets or sets the HipsResponse.
        /// </summary>
        /// <value>
        /// The response.
        /// </value>
        public HipsResponse Response
        {
            get
            {
                return response;
            }
            set
            {
                response = value;
            }
        }
    }
}