﻿using System;
using System.Runtime.Serialization;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace HIPS.PcehrSchemas
{
    /// <summary>
    /// This class defines the applicant’s response to the question of whether
    /// they consent to the inclusion of a particular type of documents from a
    /// repository into the newly created PCEHR. In order to successfully
    /// register for a PCEHR, the list of RegistrationDocumentConsent must have
    /// an entry for all 6 types of documents.
    /// </summary>
    [KnownType(typeof(RegistrationDocumentConsent))]
    [Serializable]
    [DataContract]
    public class RegistrationDocumentConsent
    {
        #region Constructor

        /// <summary>
        /// Initializes a new instance of the <see cref="RegistrationDocumentConsent"/> class.
        /// </summary>
        public RegistrationDocumentConsent()
        {
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="RegistrationDocumentConsent"/> class.
        /// </summary>
        /// <param name="type">The type.</param>
        /// <param name="status">The status.</param>
        public RegistrationDocumentConsent(RegistrationDocumentConsentType type, RegistrationDocumentConsentStatus status)
        {
            this.DocumentConsentType = type;
            this.DocumentConsentStatus = status;
        }

        #endregion Constructor

        #region Properties

        /// <summary>
        /// Gets or sets the document consent status.
        /// </summary>
        /// <value>
        /// The document consent status.
        /// </value>
        [DataMember]
        public RegistrationDocumentConsentStatus DocumentConsentStatus
        {
            get;
            set;
        }

        /// <summary>
        /// Gets or sets the type of the document consent.
        /// </summary>
        /// <value>
        /// The type of the document consent.
        /// </value>
        [DataMember]
        public RegistrationDocumentConsentType DocumentConsentType
        {
            get;
            set;
        }

        #endregion Properties
    }
}