﻿using System.ServiceModel;
using HIPS.ServiceContracts.Common.DTO;
using HIPS.ServiceContracts.Common.Message;
using EntLibVal = Microsoft.Practices.EnterpriseLibrary.Validation;

namespace HIPS.ServiceContracts.AckQueue.Message
{
    /// <summary>
    /// Web service request message for the Ack Request.
    /// </summary>
    [ServiceKnownType(typeof(RequestBase))]
    [MessageContract(WrapperNamespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.ACK_V1)]
    public class SendAckRequest : RequestBase
    {
        /// <summary>
        /// Encoded HL7® message.
        /// </summary>
        [MessageBodyMember(Order = 2)]
        [EntLibVal.Validators.NotNullValidator]
        public string Acknowledgement { get; set; }
    }
}
