﻿using System.Runtime.Serialization;

using EntLibVal = Microsoft.Practices.EnterpriseLibrary.Validation;

namespace HIPS.ServiceContracts.Common.DTO
{
    /// <summary>
    /// CDA Attachment DTO.
    /// </summary>
    [DataContract(Namespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.COMMON_V1)]
    public class CdaAttachment
    {
        /// <summary>
        /// Gets or sets the type of attachment, including whether it is the
        /// organisational logo or an additional attached image or document.
        /// </summary>
        [DataMember(IsRequired = true)]
        [EntLibVal.Validators.DomainValidator(AttachmentType.None, Negated = true)]
        public AttachmentType AttachmentType { get; set; }

        /// <summary>
        /// Gets or sets the caption that will appear on the link to this file
        /// within the CDA document.
        /// </summary>
        [DataMember(IsRequired = true)]
        [EntLibVal.Validators.StringLengthValidator(1, 1024)]
        public string Caption { get; set; }

        /// <summary>
        /// Gets or sets the binary content of the attachment.
        /// </summary>
        [DataMember(IsRequired = true)]
        [EntLibVal.Validators.NotNullValidator]
        public byte[] Content { get; set; }

        /// <summary>
        /// Gets or sets the file name of the attachment.
        /// </summary>
        [DataMember(IsRequired = true)]
        [EntLibVal.Validators.StringLengthValidator(1, 100)]
        public string FileName { get; set; }
    }
}