﻿using System.Collections.Generic;
using System.Runtime.Serialization;

namespace HIPS.ServiceContracts.Common.DTO
{
    /// <summary>
    /// CDA Content DTO.
    /// </summary>
    [DataContract(Namespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.COMMON_V1)]
    public class CdaDocumentContent
    {
        #region Properties

        /// <summary>
        /// Gets or sets the author of the CDA document.
        /// </summary>
        [DataMember(IsRequired = true)]
        public ParticipatingIndividual.ParticipatingProvider Author { get; set; }

        /// <summary>
        /// Gets or sets the document type of the CDA document.
        /// </summary>
        [DataMember(IsRequired = true)]
        public CdaCode DocumentType { get; set; }

        /// <summary>
        /// Gets or sets the patient within the CDA document.
        /// </summary>
        [DataMember(IsRequired = true)]
        public ParticipatingIndividual.ParticipatingConsumer Patient { get; set; }

        #endregion
    }
}
