﻿using System.Collections.Generic;
using System.Runtime.Serialization;

namespace HIPS.ServiceContracts.Common.DTO
{
    /// <summary>
    /// Individual Name DTO.
    /// </summary>
    [DataContract(Namespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.COMMON_V1)]
    public class IndividualName
    {
        #region Properties

        /// <summary>
        /// Gets or sets the family name of the individual.
        /// </summary>
        [DataMember(IsRequired = true)]
        public string FamilyName { get; set; }

        /// <summary>
        /// Gets or sets the given names of the individual, separated by spaces.
        /// </summary>
        [DataMember(IsRequired = true)]
        public string GivenNames { get; set; }

        /// <summary>
        /// Gets or sets the titles of the individual, separated by spaces.
        /// </summary>
        [DataMember(IsRequired = true)]
        public string Titles { get; set; }

        /// <summary>
        /// Gets or sets the suffixes of the individual, separated by spaces.
        /// </summary>
        [DataMember(IsRequired = true)]
        public string Suffixes { get; set; }

        /// <summary>
        /// Gets or sets the alias name of the individual.
        /// </summary>
        [DataMember(IsRequired = true)]
        public string KnownAs { get; set; }

        #endregion

    }
}
