﻿using System.Runtime.Serialization;

using EntLibVal = Microsoft.Practices.EnterpriseLibrary.Validation;

namespace HIPS.ServiceContracts.Common.DTO.UserIdentity
{
    /// <summary>
    /// Represents an end-user within a local directory (such as Active Directory).
    /// </summary>
    [DataContract(Namespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.COMMON_V1)]
    public class LocalUser : UserBase
    {
        #region Properties

        /// <summary>
        /// Gets or sets the name of the directory domain of the user within the local directory.
        /// </summary>
        [DataMember(IsRequired = true)]
        [EntLibVal.Validators.StringLengthValidator(1, 40)]
        public virtual string Domain { get; set; }

        /// <summary>
        /// Gets or sets the family name of the user.
        /// </summary>
        [DataMember(IsRequired = true)]
        [EntLibVal.Validators.StringLengthValidator(1, 80)]
        public virtual string FamilyName { get; set; }

        /// <summary>
        /// Gets or sets the given name(s) of the user.
        /// </summary>
        [DataMember(IsRequired = true)]
        [EntLibVal.Validators.StringLengthValidator(1, 80)]
        public virtual string GivenNames { get; set; }

        /// <summary>
        /// Gets or sets the name of the login (account) of the user within the local directory.
        /// </summary>
        [DataMember(IsRequired = true)]
        [EntLibVal.Validators.StringLengthValidator(1, 40)]
        public virtual string Login { get; set; }

        #endregion Properties
    }
}