﻿using System.ServiceModel;

using HIPS.ServiceContracts.Common.DTO.UserIdentity;

using EntLibVal = Microsoft.Practices.EnterpriseLibrary.Validation.Validators;

namespace HIPS.ServiceContracts.Common.Message
{
    /// <summary>
    /// Abstract base class for all request messages associated with service operations.
    /// </summary>
    [MessageContract(WrapperNamespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.COMMON_V1)]
    public abstract class RequestBase
    {
        #region Properties

        /// <summary>
        /// Gets or sets a value identifying the end-user associated with the request.
        /// Can be an instance of the LocalUser, ProviderUser or ResponsibleUser class.
        /// </summary>
        [MessageBodyMember(Order = 1)]
        [EntLibVal.NotNullValidator]
        [EntLibVal.ObjectValidator(ValidateActualType = true)]
        public virtual UserBase User { get; set; }

        #endregion Properties
    }
}