﻿using System.ServiceModel;

using HIPS.ServiceContracts.Common.Message;
using HIPS.ServiceContracts.Common.DTO;

using EntLibVal = Microsoft.Practices.EnterpriseLibrary.Validation;

namespace HIPS.ServiceContracts.Hpii.Message
{
    /// <summary>
    /// Web service request message for the List Local Provider operation.
    /// </summary>
    [ServiceKnownType(typeof(RequestBase))]
    public class ListLocalProviderRequest : RequestBase
    {
        /// <summary>
        /// Gets or sets Hospital Identifier.
        /// </summary>
        [MessageBodyMember(Order = 2)]
        [EntLibVal.Validators.NotNullValidator]
        [EntLibVal.Validators.ObjectValidator(ValidateActualType = true)]
        public HospitalIdentifier HospitalIdentifier { get; set; }
    }
}
