﻿using System.ServiceModel;

using HIPS.ServiceContracts.Common.DTO.PatientIdentifier;
using HIPS.ServiceContracts.Common.Message;

using EntLibVal = Microsoft.Practices.EnterpriseLibrary.Validation;

namespace HIPS.ServiceContracts.Pcehr.Message
{
    /// <summary>
    /// Web service request message for the Upload or Remove Image.
    /// </summary>
    [ServiceKnownType(typeof(RequestBase))]
    [MessageContract(WrapperNamespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.PCEHR_V2)]
    public class UploadOrRemoveImagingRequest : RequestBase
    {
        /// <summary>
        /// The HL7® message.
        /// </summary>
        [MessageBodyMember(Order = 1)]
        [EntLibVal.Validators.NotNullValidator]
        public string HL7Message { get; set; }

        /// <summary>
        /// The PDF report as base 64 encoded binary content.
        /// </summary>
        [MessageBodyMember(Order = 2)]
        public byte[] Report { get; set; }

        /// <summary>
        /// The file path to the report location.
        /// </summary>
        [MessageBodyMember(Order = 3)]
        public string ReportLocation { get; set; }
    }
}
