﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using HIPS.CommonSchemas;
using HIPS.CommonSchemas.PatientIdentifier;
using HIPS.PcehrSchemas;
using HIPS.DemoHarness.Helpers;
using System.ServiceModel;

namespace HIPS.DemoHarness
{
    public partial class DemoHarnessForm
    {
        private void inputBox_KeyDown(object sender, KeyEventArgs e)
        {
            if ((System.Windows.Forms.Control.ModifierKeys == Keys.Control) && (e.KeyCode == Keys.A))
            {
                ((TextBox)sender).SelectAll();
                e.Handled = true;
            }
        }

        private void inputBox_TextChanged(object sender, EventArgs e)
        {
            outputBox.Text = "Message has not been sent yet";
        }

        void hl7ComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            inputBox.Text = hl7ComboBox.SelectedValue.ToString();
        }

        /// <summary>
        /// Handles the Click event of the notifyPasButton control.
        /// </summary>
        /// <param name="sender">The source of the event.</param>
        /// <param name="e">The <see cref="System.EventArgs"/> instance containing the event data.</param>
        private void notifyPasButton_Click(object sender, EventArgs e)
        {
            this.Cursor = Cursors.WaitCursor;
            outputBox.Text = "Processing the Message";
            ClearDatastoreResults();
            SetPanel(StatusPanelType.Status, "Waiting for PAS message to be processed");
            this.Refresh();
            var client = GetDatabaseLoaderServiceClient();

            try
            {
                DateTime submittedTime = DateTime.Now.AddSeconds(-4);
                string text = inputBox.Text;
                inputBox.Text = string.Empty;
                var messages = SplitHl7Messages(text);
                foreach (var message in messages)
                {
                    outputBox.Text = client.NotifyPasEvent(message.Replace("\r\n", "\r"), GetUser()).Replace("\r", "\r\n");
                }
                string mrn = GetMrnFromPasMessage(text);
                string hospitalCode = GetHospitalCode(text);
                GetPatientByHospitalMrn(mrn, hospitalCode);
                SetAuditResults(submittedTime);
                for (int i = 2; i <= NumberOfEpisodes.Value; i++)
                {
                    DateTime admissionDate = GetAdmissionDate(text);

                    string oldDate = admissionDate.ToString("yyyyMMddhhmmss");
                    // create a new mrn
                    //string newMrn = mrn + (i-1).ToString();
                    //TODO: need to change the visit number, not the MRN.
                    // decrement the admission date each time
                    admissionDate = admissionDate.AddDays(i * (-1));
                    string newDate = admissionDate.ToString("yyyyMMhhmmss");
                    string hl7message = text.Replace(oldDate, newDate);
                    hl7message = ChangeVisitNumber(hl7message, i);
                    //hl7message = hl7message.Replace(mrn, newMrn);
                    string response = client.NotifyPasEvent(hl7message.Replace("\r\n", "\r"), GetUser()).Replace("\r", "\r\n");

                    //        for (int i = 1; i <= NumberOfDocs; i++)
                    //{
                    //    string newMrn = MrnPrefix + i.ToString();
                    //    //episodeList.Add(new Episode(newMrn, GetCdaDocument(), DateTime.Now.AddDays(i-NumberOfDocs)));
                }
            }
            catch (FaultException<ExceptionDetail> ex)
            {
                outputBox.Text = ex.Message + "\r\n\r\n" + ex.Detail.StackTrace;
            }
            catch (Exception ex)
            {
                outputBox.Text = ex.Message;
            }

            // Always close the client.
            try
            {
                client.Close();
            }
            catch (CommunicationObjectFaultedException)
            {
                // Ignore
            }
            this.Cursor = Cursors.IBeam;
        }

        /// <summary>
        /// Splits the text into the constituent HL7 messages.
        /// </summary>
        /// <param name="text"></param>
        /// <returns></returns>
        private IEnumerable<string> SplitHl7Messages(string text)
        {
            text = text.Replace("\r\n", "\n");
            var lines = text.Split('\n');
            var messages = new List<string>();
            StringBuilder sb = new StringBuilder();
            foreach (var line in lines)
            {
                if (line.StartsWith("MSH"))
                {
                    if (sb.Length != 0)
                    {
                        messages.Add(sb.ToString());
                        sb.Clear();
                    }
                    sb.AppendLine(line);
                }
                else if (!line.StartsWith("-") && !string.IsNullOrWhiteSpace(line))
                {
                    sb.AppendLine(line);
                }
            }
            messages.Add(sb.ToString());
            return messages;
        }

        /// <summary>
        /// Returns a new HL7 message with a modified datetime
        /// </summary>
        /// <param name="newAdmissionDate">The new admission date.</param>
        /// <returns></returns>
        private string ChangeVisitNumber(string hl7message, int visit)
        {
            //DateTime result = DateTime.Now;
            //return hl7message.Replace(
            string[] lines = hl7message.Split('\n');
            int i = 0;
            foreach (string line in lines)
            {

                int p = line.IndexOf("PV1|");
                if (p > -1)
                {
                    string[] segments = line.Split('|');
                    string admissionDate = segments[44];
                    segments[19] = visit.ToString();
                    lines[i] = String.Join("|", segments);
                    break;
                }
                i++;
            }

            return String.Join("\n", lines);
        }

        /// <summary>
        /// HL7 input box key press event handler.
        /// </summary>
        /// <param name="sender">Event sender</param>
        /// <param name="e">Event arguments</param>
        private void inputBox_KeyPress(object sender, KeyPressEventArgs e)
        {
            // code for Ctrl-A is 1
            if (e.KeyChar == 1)
            {
                inputBox.SelectAll();
            }
        }

        /// <summary>
        /// Add episode button click event handler.
        /// </summary>
        /// <param name="sender">Event sender</param>
        /// <param name="e">Event arguments</param>
        private void addEpisodeButton_Click(object sender, EventArgs e)
        {
            inputBox.AppendText(Resource.HL7EpisodeSegments);
        }

        private void tab2AuditDataGridView_CellClick(object sender, DataGridViewCellEventArgs e)
        {
            AnyAuditDataGridViewClick(sender, e);

            //DataGridView view = sender as DataGridView;
            //if (e.ColumnIndex == 1 || e.ColumnIndex == 2)
            //{
            //    string title = (e.ColumnIndex == 1) ? "Request Message" : "Response Message";
            //     MessageForm form = new MessageForm(title,PrintXml(view.CurrentCell.Value.ToString()));
            //    form.ShowDialog();
            //}
        }

    }
}
