﻿using System;
using System.Collections.Generic;
using System.Linq;

using DTO = HIPS.ServiceContracts.Common;
using Model = HIPS.CommonSchemas;

namespace HIPS.AppServer.ServiceHost.Utility
{

    /// <summary>
    /// Extensions for working with model classes.
    /// </summary>
    internal static class ModelExtensions
    {

        #region Methods

        /// <summary>
        /// Convert from a DTO CdaPackageFormat enumeration value to its corresponding model CdaPackageFormat enumeration value.
        /// </summary>
        /// <param name="item">The source CdaPackageFormat.</param>
        /// <returns>The corresponding enumeration value.</returns>
        internal static Model.CdaPackageFormat ToCommonModel(this DTO.CdaPackageFormat item)
        {
            switch (item)
            {
                case DTO.CdaPackageFormat.Hl7Mdm:
                    {
                        return Model.CdaPackageFormat.Hl7Mdm;
                    }
                case DTO.CdaPackageFormat.XdmZip:
                    {
                        return Model.CdaPackageFormat.XdmZip;
                    }
                default:
                    {
                        return Model.CdaPackageFormat.None;
                    }
            }
        }

        /// <summary>
        /// Converts from a common model SexEnumerator enumeration value to its corresponding string representation.
        /// </summary>
        /// <param name="item">The source SexEnumerator.</param>
        /// <returns>The corresponding string value.</returns>
        internal static string ToService(this HIPS.PcehrDataStore.Schemas.Enumerators.SexEnumerator item)
        {
            switch (item)
            {
                case PcehrDataStore.Schemas.Enumerators.SexEnumerator.Female:
                    {
                        return "F";
                    }
                case PcehrDataStore.Schemas.Enumerators.SexEnumerator.IntersexOrIndeterminate:
                    {
                        return "I";
                    }
                case PcehrDataStore.Schemas.Enumerators.SexEnumerator.Male:
                    {
                        return "M";
                    }
                case PcehrDataStore.Schemas.Enumerators.SexEnumerator.NotStatedOrInadequatelyDescribed:
                    {
                        return "N";
                    }
                default:
                    {
                        return "N";
                    }
            }
        }

        /// <summary>
        /// Converts from a common model SexEnumerator enumeration value to its corresponding string representation.
        /// </summary>
        /// <param name="item">The source SexEnumerator.</param>
        /// <returns>The corresponding string value.</returns>
        internal static PcehrDataStore.Schemas.Enumerators.SexEnumerator ToSexEnumerator(this string sex)
        {
            switch (sex)
            {
                case "Female":
                case "F":
                    {
                        return PcehrDataStore.Schemas.Enumerators.SexEnumerator.Female;
                    }
                case "IntersexOrIndeterminate":
                case "I":
                    {
                        return PcehrDataStore.Schemas.Enumerators.SexEnumerator.IntersexOrIndeterminate;
                    }
                case "Male":
                case "M":
                    {
                        return PcehrDataStore.Schemas.Enumerators.SexEnumerator.Male;
                    }
                case "NotStatedOrInadequatelyDescribed":
                case "N":
                    {
                        return PcehrDataStore.Schemas.Enumerators.SexEnumerator.NotStatedOrInadequatelyDescribed;
                    }
                default:
                    {
                        return PcehrDataStore.Schemas.Enumerators.SexEnumerator.NotStatedOrInadequatelyDescribed;
                    }
            }
        }

        #endregion

    }

}
