﻿using System;
using System.Runtime.Serialization;

namespace HIPS.Base.DataAccess
{
    /// <summary>
    /// This exception represents the failure of a concurrency check when updating a record in the database.
    /// </summary>
    [Serializable]
    public class ConcurrencyCheckFailException : System.Exception
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="ConcurrencyCheckFailException"/> class.
        /// </summary>
        public ConcurrencyCheckFailException()
            : base("Unable to save object. The record has been modified since it was last retrieved.")
        {
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="ConcurrencyCheckFailException"/> class.
        /// </summary>
        /// <param name="Message">The message.</param>
        public ConcurrencyCheckFailException(string Message)
            : base(Message)
        {
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="ConcurrencyCheckFailException"/> class.
        /// </summary>
        /// <param name="Message">The message.</param>
        /// <param name="InnerException">The inner exception.</param>
        public ConcurrencyCheckFailException(string Message, System.Exception InnerException)
            : base(Message, InnerException)
        {
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="ConcurrencyCheckFailException"/> class.
        /// </summary>
        /// <param name="Info">The info.</param>
        /// <param name="Context">The context.</param>
        protected ConcurrencyCheckFailException(SerializationInfo Info, StreamingContext Context)
            : base(Info, Context)
        {
        }
    }
}