﻿using System;
using System.Diagnostics;
using System.Xml.Serialization;

namespace HIPS.BusinessEntities.ResponseEntities
{
    /// <summary>
    /// Web service response for hospital details.
    /// </summary>
    [Serializable]
    [DebuggerStepThrough]
    [XmlRoot(Namespace = "http://schemas.HIPS/WebServices/2012/01", ElementName = "HospitalDetailsResponse")]
    [XmlType(Namespace = "http://schemas.HIPS/WebServices/2012/01", IncludeInSchema = true)]
    public class HospitalDetailsResponse
    {
        private HospitalDetailsResult _hospitalDetailsResult;

        /// <summary>
        /// Initialises a new instance of the <see cref="HospitalDetailsResponse"/> class.
        /// </summary>
        public HospitalDetailsResponse()
        {
            _hospitalDetailsResult = new HospitalDetailsResult();
        }

        /// <summary>
        /// Gets or sets the hospital details result.
        /// </summary>
        [XmlElement(Namespace = "http://schemas.HIPS/WebServices/2012/01", Order = 0)]
        public HospitalDetailsResult GetHospitalDetailsResult
        {
            get { return _hospitalDetailsResult; }
            set { _hospitalDetailsResult = value; }
        }

        /// <summary>
        /// Web service result for hospital details.
        /// </summary>
        public class HospitalDetailsResult
        {
            private string addressLine1;

            private string addressLine2;

            private string fax;

            private string hospitalName;

            private string hpio;

            private string phone;

            private string placeName;

            private string postcode;

            private string state;

            /// <summary>
            /// Initialises a new instance of the <see cref="HospitalDetailsResult"/> class.
            /// </summary>
            public HospitalDetailsResult()
            {
            }

            /// <summary>
            /// Gets or sets the first line of the address.
            /// </summary>
            [XmlElement(Namespace = "http://schemas.HIPS/WebServices/2012/01", Order = 4)]
            public string AddressLine1
            {
                get { return this.addressLine1; }
                set { this.addressLine1 = value; }
            }

            /// <summary>
            /// Gets or sets the second line of the address.
            /// </summary>
            [XmlElement(Namespace = "http://schemas.HIPS/WebServices/2012/01", Order = 5)]
            public string AddressLine2
            {
                get { return this.addressLine2; }
                set { this.addressLine2 = value; }
            }

            /// <summary>
            /// Gets or sets the fax number.
            /// </summary>
            [XmlElement(Namespace = "http://schemas.HIPS/WebServices/2012/01", Order = 0)]
            public string Fax
            {
                get { return this.fax; }
                set { this.fax = value; }
            }

            /// <summary>
            /// Gets or sets the hospital name.
            /// </summary>
            [XmlElement(Namespace = "http://schemas.HIPS/WebServices/2012/01", Order = 2)]
            public string HospitalName
            {
                get { return this.hospitalName; }
                set { this.hospitalName = value; }
            }

            /// <summary>
            /// Gets or sets the HPI-O number.
            /// </summary>
            [XmlElement(Namespace = "http://schemas.HIPS/WebServices/2012/01", Order = 3)]
            public string Hpio
            {
                get { return this.hpio; }
                set { this.hpio = value; }
            }

            /// <summary>
            /// Gets or sets the phone number.
            /// </summary>
            [XmlElement(Namespace = "http://schemas.HIPS/WebServices/2012/01", Order = 1)]
            public string Phone
            {
                get { return this.phone; }
                set { this.phone = value; }
            }

            /// <summary>
            /// Gets or sets the suburb, town or locality name.
            /// </summary>
            [XmlElement(Namespace = "http://schemas.HIPS/WebServices/2012/01", Order = 6)]
            public string PlaceName
            {
                get { return this.placeName; }
                set { this.placeName = value; }
            }

            /// <summary>
            /// Gets or sets the postcode.
            /// </summary>
            [XmlElement(Namespace = "http://schemas.HIPS/WebServices/2012/01", Order = 8)]
            public string Postcode
            {
                get { return this.postcode; }
                set { this.postcode = value; }
            }

            /// <summary>
            /// Gets or sets the state.
            /// </summary>
            [XmlElement(Namespace = "http://schemas.HIPS/WebServices/2012/01", Order = 7)]
            public string State
            {
                get { return this.state; }
                set { this.state = value; }
            }
        }
    }
}