﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using AutoMapper;
using ModelSchemas = HIPS.CommonSchemas;
using NehtaSchemas = Nehta.VendorLibrary.CDA;

namespace HIPS.CommonBusinessLogic.Mapping.Profiles
{
    public class PathologyReportProfile : Profile
    {
        protected override void Configure()
        {
            // Model --> NEHTA

            this.CreateMap<ModelSchemas.Cda.CdaPathDIDocumentDetails, NehtaSchemas.Common.PathologyResultReport>()
                .ForMember(dest => dest.DocumentCreationTime, opt => opt.MapFrom(src => src.CdaDocumentDetails.Metadata.DocumentCreationDateTime))
                .ForMember(
                    dest => dest.DocumentStatus,
                    opt => opt.MapFrom(
                        src => src.CdaDocumentDetails.Metadata.SourceDocumentStatus == ModelSchemas.Cda.SourceDocumentStatus.Final
                            ? NehtaSchemas.Generator.Enums.DocumentStatus.Final
                            : src.CdaDocumentDetails.Metadata.SourceDocumentStatus == ModelSchemas.Cda.SourceDocumentStatus.Interim
                            ? NehtaSchemas.Generator.Enums.DocumentStatus.Interim
                            : src.CdaDocumentDetails.Metadata.SourceDocumentStatus == ModelSchemas.Cda.SourceDocumentStatus.Withdrawn
                            ? NehtaSchemas.Generator.Enums.DocumentStatus.Withdrawn
                            : NehtaSchemas.Generator.Enums.DocumentStatus.Final))
                .ForMember(dest => dest.IncludeLogo, opt => opt.MapFrom(src => src.CdaDocumentDetails.Attachments.Exists(a => a.AttachmentType == ModelSchemas.Cda.AttachmentType.OrganisationalLogoPng)))
                .ForMember(dest => dest.LogoPath, opt => opt.MapFrom(src => src.CdaDocumentDetails.Attachments.SingleOrDefault(a => a.AttachmentType == ModelSchemas.Cda.AttachmentType.OrganisationalLogoPng).FileName))
                .ForMember(dest => dest.LogoContent, opt => opt.MapFrom(src => src.CdaDocumentDetails.Attachments.SingleOrDefault(a => a.AttachmentType == ModelSchemas.Cda.AttachmentType.OrganisationalLogoPng).Content))
                .ForMember(dest => dest.CDAContext, opt => opt.MapFrom(src => src.CdaDocumentDetails))
                .ForMember(dest => dest.SCSContent, opt => opt.MapFrom(src => src))
                .ForMember(dest => dest.SCSContext, opt => opt.MapFrom(src => src))
                .ForMember(dest => dest.ShowAdministrativeObservationsSection, opt => opt.UseValue(false));

            // CDAContext
            // Mapping for Custodian: Facility profile (Diagnostic Imaging - CDAContext - Custodian)
            // Mapping for LegalAuthenticator: Provider profile (Diagnostic Imaging - CDAContext - LegalAuthenticator)
            this.CreateMap<ModelSchemas.Cda.CdaDocumentDetails, NehtaSchemas.CDAModel.ICDAContextPathologyResultReport>()
                .ConstructUsing((ResolutionContext ctx) => NehtaSchemas.Common.PathologyResultReport.CreateCDAContext())
                .ForMember(dest => dest.DocumentId, opt => opt.MapFrom(src => src.DocumentId))
                .ForMember(dest => dest.SetId, opt => opt.MapFrom(src => src.DocumentSetId))
                .ForMember(dest => dest.Version, opt => opt.MapFrom(src => src.Version))
                .ForMember(dest => dest.Custodian, opt => opt.MapFrom(src => src))
                .ForMember(dest => dest.LegalAuthenticator, opt => opt.MapFrom(src => src));

            // SCSContext
            // Mapping for Author: Provider profile (Pathology - SCSContext - Author).
            // Mapping for ReportingPathologist: Provider profile (Pathology - SCSContext - ReportingPathologist)
            // Mapping for SubjectOfCare: SubjectOfCare profile (Pathology - SCSContext - SubjectOfCare)
            // Mapping for OrderDetails: OrderDetails profile (Pathology - SCSContext - OrderDetails)
            this.CreateMap<ModelSchemas.Cda.CdaPathDIDocumentDetails, NehtaSchemas.SCSModel.IPathologyResultReportContext>()
                .ConstructUsing((ResolutionContext ctx) => NehtaSchemas.Common.PathologyResultReport.CreateSCSContext())
                .ForMember(dest => dest.Author, opt => opt.MapFrom(src => src.CdaDocumentDetails))
                .ForMember(dest => dest.ReportingPathologist, opt => opt.MapFrom(src => src.CdaDocumentDetails))
                .ForMember(dest => dest.SubjectOfCare, opt => opt.MapFrom(src => src))
                .ForMember(dest => dest.OrderDetails, opt => opt.MapFrom(src => src));


            // SCSContent
            // Mapping for PathologyTestResult: PathologyTestResult profile (Pathology - SCSContent - ImagingExaminationResults)
            // Mapping for RelatedDocument: RelatedDocument profile (Pathology - SCSContent - RelatedDocument)
            this.CreateMap<ModelSchemas.Cda.CdaPathDIDocumentDetails, NehtaSchemas.SCSModel.Pathology.IPathologyResultReportContent>()
                .ConstructUsing((ResolutionContext ctx) => NehtaSchemas.Common.PathologyResultReport.CreateSCSContent())
                .ForMember(dest => dest.PathologyTestResult, opt => opt.MapFrom(src => src.PathologyTestResult))
                .ForMember(dest => dest.RelatedDocument, opt => opt.MapFrom(src => src));
        }
    }
}
