﻿using HIPS.CommonSchemas;
using Nehta.VendorLibrary.CDAPackage;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace HIPS.CommonBusinessLogic.Utility
{
    /// <summary>
    /// Contains extensions to assist working with NEHTA CDA Package model classes.
    /// </summary>
    internal static class CdaPackageModelUtility
    {
        /// <summary>
        /// Converts the Participant to an Approver, which will go into the CDA_SIGN.XML file in the CDA package.
        /// </summary>
        /// <param name="participant">The person who should be the approver.</param>
        /// <returns>The CDA signature approver.</returns>
        internal static Approver ToApprover(this Participant participant)
        {
            Approver approver = new Approver();
            approver.PersonGivenNames = participant.GivenNames;
            approver.PersonFamilyName = participant.FamilyName;
            approver.PersonTitles = participant.Titles;
            approver.PersonNameSuffixes = participant.Suffixes;
            approver.PersonId = participant.Identifiers[0].QualifiedIdentifier;
            return approver;
        }
    }
}
