﻿namespace HIPS.CommonSchemas.Cda
{
    /// <summary>
    /// Common model for a code element from a CDA document.
    /// </summary>
    public class CdaCode
    {
        /// <summary>
        /// Gets or sets the code.
        /// </summary>
        public string Code { get; set; }

        /// <summary>
        /// Gets or sets the OID that represents the code system.
        /// </summary>
        public string CodeSystem { get; set; }

        /// <summary>
        /// Gets or sets the name of the code system.
        /// </summary>
        public string CodeSystemName { get; set; }

        /// <summary>
        /// Gets or sets the display name for the code.
        /// </summary>
        public string DisplayName { get; set; }
    }
}