﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace HIPS.CommonSchemas.Cda
{
    /// <summary>
    /// Store all of the Diagnostic Imaging Examiniation Result Data. 
    /// </summary>
    public class ImagingExamResult
    {
        /// <summary>
        /// The test result object commn across the PathologyTestResult and ImagingExamResult objects.
        /// </summary>
        public TestResult TestResult { get; set; }
        
        /// <summary>
        /// The imaging method used to perform the examination.
        /// </summary>
        public string Modality { get; set; }
        
        /// <summary>
        /// The anatomical locations to which this examination result refers.
        /// </summary>
        public List<string> AnatomicalSite { get; set; }
        
        /// <summary>
        /// Additional details of imaging examination methodology followed.
        /// </summary>
        public string Procedure { get; set; }
        
        /// <summary>
        /// Date and optionally time, the imaging examination was performed.
        /// </summary>
        public DateTime ImageDateTime { get; set; }
        
        /// <summary>
        /// A link to a related image of interest.
        /// </summary>
        public string RelatedImageUrl { get; set; }
    }
}
