﻿using System;
using System.Runtime.Serialization;
using HIPS.Base.Schemas;
using HIPS.Base.Schemas.Enumerators;

namespace HIPS.CommonSchemas.Hi
{
    /// <summary>
    /// This class represents a HI LevelType for addressing
    /// </summary>
    [KnownType(typeof(HiLevelType))]
    [Serializable]
    [DataContract]
    public class HiLevelType : BaseExposedCode
    {
        /// <summary>
        /// Initialises a new instance of the <see cref="HiLevelType"/> class.
        /// </summary>
        public HiLevelType()
            : base()
        {
        }

        /// <summary>
        /// Gets or sets the LevelType id.
        /// </summary>
        /// <value>
        /// The LevelType id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.ApplicationGeneratedKey)]
        public int? LevelTypeId
        {
            get
            {
                return base.Id;
            }
            set
            {
                base.Id = value;
            }
        }
    }
}