﻿using System;
using System.Runtime.Serialization;
using HIPS.Base.Schemas;
using HIPS.Base.Schemas.Enumerators;

namespace HIPS.CommonSchemas.Hi
{
    /// <summary>
    /// This class represents a HI Sex
    /// </summary>
    [KnownType(typeof(HiSex))]
    [Serializable]
    [DataContract]
    public class HiSex : BaseExposedCode
    {
        /// <summary>
        /// Initialises a new instance of the <see cref="HiSex"/> class.
        /// </summary>
        public HiSex()
            : base()
        {
        }

        /// <summary>
        /// Gets or sets the Sex id.
        /// </summary>
        /// <value>
        /// The Sex id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.ApplicationGeneratedKey)]
        public int? SexId
        {
            get
            {
                return base.Id;
            }
            set
            {
                base.Id = value;
            }
        }
    }
}