﻿using System;
using System.Runtime.Serialization;

namespace HIPS.HpiiSchemas
{
    /// <summary>
    /// This class is used for the Batch Asynchronous Retrieval Request of the HPI-I Queries for identifier and demographic searches
    /// </summary>

    [KnownType(typeof(HpiiBatchAsyncRetrieveRequest))]
    [Serializable]
    [DataContract]
    public class HpiiBatchAsyncRetrieveRequest
    {
        #region Private Members

        private string batchIdentifier;
        private string hpioNumber;

        #endregion Private Members

        #region Properties

        /// <summary>
        /// Gets or sets the BatchIdentifier
        /// </summary>
        /// <value>
        /// The batchIdentifier
        /// </value>
        [DataMember]
        public string BatchIdentifier
        {
            get { return batchIdentifier; }
            set { batchIdentifier = value; }
        }

        /// <summary>
        /// Gets or sets the HpioNumber - This is an over arching HPIO which will be used for all queries in the batch
        /// </summary>
        /// <value>
        /// The hpioNumber
        /// </value>
        [DataMember]
        public string HpioNumber
        {
            get { return hpioNumber; }
            set { hpioNumber = value; }
        }

        #endregion Properties
    }
}