﻿using System;
using System.Runtime.Serialization;

namespace HIPS.HpiiSchemas
{
    /// <summary>
    /// This object is used for HPI-I Queries for a demographic query
    /// </summary>
    ///
    [KnownType(typeof(HpiiDemographicQuery))]
    [Serializable]
    [DataContract]
    public class HpiiDemographicQuery : HpiiQuery
    {
        #region Private Members

        private AustralianAddress australianAddress;
        private InternationalAddress internationalAddress;

        #endregion Private Members

        #region Properties

        /// <summary>
        /// Gets or sets the AustralianAddress
        /// </summary>
        /// <value>
        /// The australianAddress
        /// </value>
        [DataMember]
        public AustralianAddress AustralianAddress
        {
            get { return australianAddress; }
            set { australianAddress = value; }
        }

        /// <summary>
        /// Gets or sets the InternationalAddress
        /// </summary>
        /// <value>
        /// The internationalAddress
        /// </value>
        [DataMember]
        public InternationalAddress InternationalAddress
        {
            get { return internationalAddress; }
            set { internationalAddress = value; }
        }

        #endregion Properties
    }
}