﻿using System.Runtime.Serialization;
using HIPS.CommonSchemas;
using HIPS.CommonSchemas.PatientIdentifier;

namespace HIPS.IhiSchemas.Schemas
{
    /// <summary>
    /// This class is used for the response from the IHI validation methods.
    /// </summary>
    [KnownType(typeof(ValidatedIhiResponse))]
    [DataContract]
    public class ValidatedIhiResponse
    {
        #region Private Fields

        private StatePatientId enterprisePatientIdentifier;
        private HipsResponse hipsResponse;
        private Mrn hospitalPatientIdentifier;
        private ValidatedIhi nationalPatientIdentifier;

        #endregion Private Fields

        #region properties

        /// <summary>
        /// Gets or sets the HIPS response with information about success or the reason for failure.
        /// </summary>
        /// <value>
        /// The the HIPS response with information about success or the reason for failure.
        /// </value>
        [DataMember]
        public HipsResponse HipsResponse
        {
            get
            {
                return hipsResponse;
            }
            set
            {
                hipsResponse = value;
            }
        }

        /// <summary>
        /// Gets or sets the hospital patient identifier (MRN).
        /// </summary>
        /// <value>
        /// The hospital patient identifier (MRN).
        /// </value>
        [DataMember]
        public Mrn Mrn
        {
            get
            {
                return hospitalPatientIdentifier;
            }
            set
            {
                hospitalPatientIdentifier = value;
            }
        }

        /// <summary>
        /// Gets or sets the enterprise patient identifier.
        /// </summary>
        /// <value>
        /// The enterprise patient identifier.
        /// </value>
        [DataMember]
        public StatePatientId StatePatientId
        {
            get
            {
                return enterprisePatientIdentifier;
            }
            set
            {
                enterprisePatientIdentifier = value;
            }
        }

        /// <summary>
        /// Gets or sets the national patient identifier.
        /// </summary>
        /// <value>
        /// The national patient identifier.
        /// </value>
        [DataMember]
        public ValidatedIhi ValidatedIhi
        {
            get
            {
                return nationalPatientIdentifier;
            }
            set
            {
                nationalPatientIdentifier = value;
            }
        }

        #endregion properties
    }
}