﻿using System.Data.SqlClient;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.PcehrDataStore.Schemas;

namespace HIPS.PcehrDataStore.DataAccess
{
    /// <summary>
    /// This class provides access to the IHI Lookup Alert table
    /// </summary>
    public class IhiLookupAlertDl : BaseDl
    {
        #region Methods

        /// <summary>
        /// Inserts the specified item.
        /// </summary>
        /// <param name="item">The item.</param>
        /// <returns></returns>
        public bool Insert(IhiLookupAlert item, SqlTransaction transaction = null)
        {
            using (SqlCommand command = GetSqlCommand("hips.IhiLookupAlertInsert", transaction))
            {
                return base.Insert<IhiLookupAlert>(item, command);
            }
        }

        #endregion Methods
    }
}