﻿using System;

namespace HIPS.PcehrDataStore.Schemas.Enumerators
{
    /// <summary>
    /// This enumeration defines the list of acceptable forms of evidence of
    /// identity. The user must select one of the following Identity Verification
    /// Methods used by the healthcare organisation to verify the consumer’s or
    /// authorised representative’s identity. The CIS must display the exact method
    /// description to the user as outlined below.
    /// </summary>
    [Serializable]
    public enum EvidenceOfIdentityType
    {
        /// <summary>
        /// Attending third or more consultation and Medicare/DVA card.
        /// </summary>
        IdentityVerificationMethod1 = 1,

        /// <summary>
        /// Attending hospital with their clinical referral and Medicare/DVA card
        /// </summary>
        IdentityVerificationMethod2 = 2,

        /// <summary>
        /// Attending emergency department with PHOTO ID with Medicare/DVA card
        /// </summary>
        IdentityVerificationMethod3 = 3,

        /// <summary>
        /// Having prescriptions filled on three or more occasions in the past year and Medicare/DVA card
        /// </summary>
        IdentityVerificationMethod4 = 4,

        /// <summary>
        /// Enrolled and attending Aboriginal Medical Service and Medicare/DVA card
        /// </summary>
        IdentityVerificationMethod5 = 5,

        /// <summary>
        /// Attending third or more consultation and has a My eHealth Record
        /// </summary>
        IdentityVerificationMethod6 = 6,

        /// <summary>
        /// Identity verified by referee consistent with My eHealth Record requirements
        /// </summary>
        IdentityVerificationMethod7 = 7,

        /// <summary>
        /// Resident of Aged Care facility and Medicare/DVA card
        /// </summary>
        IdentityVerificationMethod8 = 8,

        /// <summary>
        /// 100pts of documentary evidence consistent with PCEHR Consumer Identity Framework
        /// </summary>
        IdentityVerificationMethod9 = 9,

        /// <summary>
        /// Other criteria approved by the System Operator
        /// </summary>
        IdentityVerificationMethod10 = 10,
    }

    /// <summary>
    /// This enumeration defines the list of acceptable choices for indigenous
    /// status. The CIS may either prepopulate the Indigenous Status from the
    /// local patient record, or require the user to indicate the status. It
    /// must not default the status to a specific value.
    /// </summary>
    [Serializable]
    public enum IndigenousStatus
    {
        /// <summary>
        /// Aboriginal but not Torres Strait Islander
        /// </summary>
        AboriginalNotTorresStraitIslander = 1,

        /// <summary>
        /// Torres Strait Islander but not Aboriginal
        /// </summary>
        TorresStraitIslanderNotAboriginal = 2,

        /// <summary>
        /// Both Aboriginal and Torres Strait Islander
        /// </summary>
        BothAboriginalAndTorresStraitIslander = 3,

        /// <summary>
        /// Neither Aboriginal nor Torres Strait Islander
        /// </summary>
        NeitherAboriginalAndTorresStraitIslander = 4,

        /// <summary>
        /// Not Stated or Inadequately Described
        /// </summary>
        NotStatedInadequatelyDescribed = 9,
    }

    /// <summary>
    /// This enumeration lists the possible channels that the applicant may choose for delivery of the IVC.
    /// </summary>
    [Serializable]
    public enum IvcCorrespondenceChannel
    {
        /// <summary>
        /// The applicant did not choose a channel.
        /// </summary>
        notselected,

        /// <summary>
        /// The IVC will be emailed to the email address.
        /// </summary>
        email,

        /// <summary>
        /// The IVC will be sent to the mobile phone number via SMS.
        /// </summary>
        sms,

        /// <summary>
        /// The IVC will be returned in the web service response to be displayed on screen.
        /// </summary>
        response,

        /// <summary>
        /// The IVC will be sent in a letter to the address on file with Medicare.
        /// </summary>
        mail,

        /// <summary>
        /// No IVC will be provided.
        /// </summary>
        none,
    }

    /// <summary>
    /// This enumeration lists the possible responses that the applicant
    /// may give for the consent to load a type of documents from a repository
    /// into the newly created PCEHR.
    /// </summary>
    [Serializable]
    public enum RegistrationDocumentConsentStatus
    {
        /// <summary>
        /// The applicant gave consent for this type
        /// </summary>
        ConsentGiven,

        /// <summary>
        /// The applicant did not give consent for this type
        /// </summary>
        ConsentNotGiven,
    }

    /// <summary>
    /// This enumeration lists the possible types of documents that can be
    /// automatically loaded from a repository into the newly created PCEHR.
    /// </summary>
    [Serializable]
    public enum RegistrationDocumentConsentType
    {
        /// <summary>
        /// Australian Childhood Immunisation Registry
        /// </summary>
        ACIR,

        /// <summary>
        /// Australian Organ Donor Registry
        /// </summary>
        AODR,

        /// <summary>
        /// Future Medicare Benefits Scheme (MBS) records
        /// </summary>
        MBS,

        /// <summary>
        /// Past MBS records
        /// </summary>
        MBSPastAssimilation,

        /// <summary>
        /// Future Pharmaceutical Benefits Scheme (PBS) records
        /// </summary>
        PBS,

        /// <summary>
        /// Past PBS records
        /// </summary>
        PBSPastAssimilation,
    }
}