﻿using System;
using System.Runtime.Serialization;
using HIPS.Base.Schemas;
using BaseEnumerators = HIPS.Base.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents a Code System
    /// </summary>
    [KnownType(typeof(CodeSystem))]
    [Serializable]
    [DataContract]
    public class CodeSystem : BaseCodeListSchema
    {
        #region Private Members

        private string oid;
        private string version;
        private string hl7FieldPosition;

        #endregion Private Members

        #region Properties

        /// <summary>
        /// Gets or sets the code system id.
        /// </summary>
        /// <value>
        /// The code system id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.AutoGeneratedKey)]
        public int? CodeSystemId
        {
            get
            {
                return base.Id;
            }
            set
            {
                base.Id = value;
            }
        }

        /// <summary>
        /// Gets or sets the oid.
        /// </summary>
        /// <value>
        /// The oid.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string Oid
        {
            get
            {
                return oid;
            }
            set
            {
                oid = value;
#if PUMA_CLIENT
                RaisePropertyChanged(() => Oid);
#endif
            }
        }

        /// <summary>
        /// Gets or sets the version of the code system.
        /// </summary>
        /// <value>
        /// The version.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string Version
        {
            get
            {
                return version;
            }
            set
            {
                version = value;
#if PUMA_CLIENT
                RaisePropertyChanged(() => Version);
#endif
            }
        }

        /// <summary>
        /// Gets or sets the HL7FieldPosition.
        /// </summary>
        /// <value>
        /// The oid.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string HL7FieldPosition
        {
            get
            {
                return hl7FieldPosition;
            }
            set
            {
                hl7FieldPosition = value;
            }
        }

        #endregion Properties
    }
}