﻿using System;
using System.Runtime.Serialization;
using HIPS.Base.Schemas;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents a country
    /// </summary>
    [KnownType(typeof(Country))]
    [Serializable]
    [DataContract]
    public class Country : BaseCodeListSchema
    {
        /// <summary>
        /// Gets or sets the country id.
        /// </summary>
        /// <value>
        /// The country id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(HIPS.Base.Schemas.Enumerators.DatabaseColumnType.ApplicationGeneratedKey)]
        public int? CountryId
        {
            get
            {
                return base.Id;
            }
            set
            {
                base.Id = value;
            }
        }
    }
}