﻿using System;
using System.Runtime.Serialization;
using HIPS.Base.Schemas;
using BaseEnumerators = HIPS.Base.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents a PCEHR disclosure audit.
    /// </summary>
    [KnownType(typeof(DisclosureAudit))]
    [Serializable]
    [DataContract]
    public class DisclosureAudit : BaseSchema
    {
        #region Properties

        /// <summary>
        /// Gets or sets the additional audit information, such as a scanned image of the form that the patient signed.
        /// </summary>
        /// <value>
        /// The audit information.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public byte[] AuditInformation { get; set; }

        /// <summary>
        /// Gets or sets the disclosure audit ID.
        /// </summary>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.AutoGeneratedKey)]
        public int? DisclosureAuditId
        {
            get
            {
                return base.Id;
            }
            set
            {
                base.Id = value;
            }
        }

        /// <summary>
        /// Gets or sets the health provider organisation id.
        /// </summary>
        /// <value>
        /// The health provider organisation id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int HealthProviderOrganisationId { get; set; }

        /// <summary>
        /// Gets or sets the patient master id.
        /// </summary>
        /// <value>
        /// The patient master id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int PatientMasterId { get; set; }

        /// <summary>
        /// Gets or sets the new value for PCEHR disclosed that the patient has provided.
        /// </summary>
        /// <value>
        /// The new value for PCEHR disclosed.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public bool PcehrDisclosed { get; set; }

        #endregion Properties
    }
}