﻿using System;

using HIPS.Base.Schemas;
using HIPS.Base.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas.Schemas
{
    /// <summary>
    /// FillerOrderNumber schema.
    /// </summary>
    public class FillerOrderNumber : BaseSchema
    {
        /// <summary>
        /// Gets or sets the Filler Order Number Id.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.AutoGeneratedKey)]
        public int? FillerOrderNumberId
        {
            get
            {
                return base.Id;
            }

            set
            {
                base.Id = value;
            }
        }

        /// <summary>
        /// Gets or sets the CDA set number ID.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.Data)]
        public int CdaSetNumberId { get; set; }

        /// <summary>
        /// Gets or sets the document creation date/time.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.Data)]
        public string fillerOrderNumber { get; set; }

        /// <summary>
        /// Gets or sets the document creation date/time.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.Data)]
        public string OrderIdentifier { get; set; }
    }
}
