﻿using System;
using System.Runtime.Serialization;
using HIPS.Base.Schemas;
using HIPS.Base.Schemas.Enumerators;

using BaseEnumerators = HIPS.Base.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents the information of a single health provider organisation (HPI-O).
    /// </summary>
    [KnownType(typeof(HealthProviderOrganisation))]
    [Serializable]
    [DataContract]
    public class HealthProviderOrganisation : BaseCodeListSchema
    {
        /// <summary>
        /// Gets or sets the AuthorisedEmployeeName for use with calls that only use the HPIO
        /// </summary>
        /// <value>
        /// Authorised Employee Name
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string AuthorisedEmployeeName { get; set; }

        /// <summary>
        /// Gets or sets the AuthorisedEmployeeUserId for use with calls that only use the HPIO
        /// </summary>
        /// <value>
        /// Authorised Employee User Id passed to service calls
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string AuthorisedEmployeeUserId { get; set; }

        /// <summary>
        /// Gets or sets the primary key for the HealthProviderOrganisation table.
        /// </summary>
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.ApplicationGeneratedKey)]
        public int? HealthProviderOrganisationId
        {
            get
            {
                return base.Id;
            }
            set
            {
                base.Id = value;
            }
        }

        /// <summary>
        /// Specifies which HPO network this organisation belongs to.
        /// </summary>
        /// <value>
        /// Health Provider Organisation Network Id
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int HealthProviderOrganisationNetworkId { get; set; }

        /// <summary>
        /// Gets or sets the serial number of the certificate for connecting to the HI Service.
        /// This is used to find and obtain the certificate from the certificate store for use in connections to the HI Service.
        /// </summary>
        /// <value>
        /// HI Certificate Serial Number
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string HiCertSerial { get; set; }

        /// <summary>
        /// Whether HIPS will connect to the HI Service as a CSP on behalf of this organisation.
        /// </summary>
        /// <value>
        /// HI Service CSP
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public bool HiCsp { get; set; }

        /// <summary>
        /// Gets or sets the HPI-O number of the health provider organisation.
        /// </summary>
        /// <value>
        /// HPIO Number
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string Hpio { get; set; }

        /// <summary>
        /// Hexadecimal serial number for certificate used to sign CDA documents.
        /// This must be an HPO certificate. If not provided, HIPS will be unable to upload documents to the PCEHR.
        /// </summary>
        /// <value>
        /// HPO Certificate Serial Number
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string HpoCertSerial { get; set; }

        /// <summary>
        /// Gets or sets the name of the health provider organisation.
        /// </summary>
        /// <value>
        /// Name of the health provider organisation
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets the serial number of the NASH PKI Certificate for Healthcare Provider Organisations.
        /// This is used to find and obtain the certificate from the certificate store for use in connections to the PCEHR Service
        /// and to package and sign clinical documents.
        /// </summary>
        /// <value>
        /// PCEHR Certificate Serial Number
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string PcehrCertSerial { get; set; }

        /// <summary>
        /// Whether HIPS will connect to the PCEHR system as a CSP on behalf of this organisation.
        /// </summary>
        /// <value>
        /// Pcehr Service CSP
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public bool PcehrCsp { get; set; }
    }
}