﻿using System;
using HIPS.Base.Schemas;
using HIPS.Base.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// Represents the data returned from the database for a local document meta-data items from the local document store.
    /// </summary>
    public class LocalClinicalDocumentMetaData
    {
        /// <summary>
        /// Date of Admission
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public DateTime AdmissionDate { get; set; }

        /// <summary>
        /// Gets or sets the admission reason for the episode that this document relates to.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string AdmissionReason { get; set; }

        /// <summary>
        /// Id of the ClinicalDocument
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public int ClinicalDocumentId { get; set; }

        /// <summary>
        /// Status of the document within the Local Repository
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public String ClinicalDocumentStatusDescription { get; set; }

        /// <summary>
        /// Id of the ClinicalDocumentStatusId
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public int ClinicalDocumentStatusId { get; set; }

        /// <summary>
        /// Id of the ClinicalDocumentVersionId
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public int ClinicalDocumentVersionId { get; set; }

        /// <summary>
        /// Date of Discharge
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public DateTime? DischargeDate { get; set; }

        /// <summary>
        /// The type of the Document
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string DocumentType { get; set; }

        /// <summary>
        /// Code of the Document
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string DocumentTypeCode { get; set; }

        /// <summary>
        /// Description of the Code of the Document
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string DocumentTypeDescription { get; set; }

        /// <summary>
        /// Id of the DocumentTypeId
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public int DocumentTypeId { get; set; }

        /// <summary>
        /// Id of the Episode
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public int EpisodeId { get; set; }

        /// <summary>
        /// Id of the EpisodeType
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public int EpisodeTypeId { get; set; }

        /// <summary>
        /// Id of the Hospital
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public int HospitalId { get; set; }

        /// <summary>
        /// Id of the Patient
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public int PatientId { get; set; }

        /// <summary>
        /// Queue Operation Description
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public String QueueOperationDescription { get; set; }

        /// <summary>
        /// Id of the QueueOperationId
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public int QueueOperationId { get; set; }

        /// <summary>
        /// Queue Status Description
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public String QueueStatusDescription { get; set; }

        /// <summary>
        /// Id of the QueueStatusId
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public int QueueStatusId { get; set; }

        /// <summary>
        /// The family name of the responsible provider for the most recent matching episode.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string ResponsibleProviderFamilyName { get; set; }

        /// <summary>
        /// The given names of the responsible provider.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string ResponsibleProviderGivenNames { get; set; }

        /// <summary>
        /// The suffix of the responsible provider (such as 'Jr' or 'Sr').
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string ResponsibleProviderSuffix { get; set; }

        /// <summary>
        /// The title of the responsible provider (such as 'Dr', 'Ms' or 'Mr').
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string ResponsibleProviderTitle { get; set; }

        /// <summary>
        /// Generated SourceSystemDocumentId of the document
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public String SourceSystemDocumentId { get; set; }

        /// <summary>
        /// Generated DocumentId of the document
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public String SourceSystemSetId { get; set; }

        /// <summary>
        /// Date of Supersede
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public DateTime? SupersededDate { get; set; }

        /// <summary>
        /// Date of Upload
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public DateTime? UploadedDate { get; set; }
    }
}