﻿using System;
using System.Runtime.Serialization;
using HIPS.Base.Schemas;
using BaseEnumerators = HIPS.Base.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents a patient master to an address
    /// </summary>
    [KnownType(typeof(PatientMasterAddress))]
    [Serializable]
    [DataContract]
    public class PatientMasterAddress : BaseSchema
    {
        #region Constructors

        /// <summary>
        /// Initialises a new instance of the <see cref="PatientMasterAddress"/> class.
        /// </summary>
        public PatientMasterAddress()
        {
        }

        /// <summary>
        /// Initialises a new instance of the <see cref="PatientMasterAddress"/> class.
        /// </summary>
        /// <param name="patientMasterId">The patient master id.</param>
        /// <param name="addressId">The address id.</param>
        public PatientMasterAddress(int patientMasterId, int addressId)
        {
            PatientMasterId = patientMasterId;
            AddressId = addressId;
        }

        #endregion Constructors

        /// <summary>
        /// Gets or sets the address id.
        /// </summary>
        /// <value>
        /// The address id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ApplicationGeneratedKey)]
        public int AddressId { get; set; }

        /// <summary>
        /// Gets or sets the patient master id.
        /// </summary>
        /// <value>
        /// The patient master id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ApplicationGeneratedKey)]
        public int PatientMasterId { get; set; }
    }
}