﻿using System;
using System.Runtime.Serialization;
using HIPS.Base.Schemas;
using BaseEnumerators = HIPS.Base.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents a patients IHI historic record
    /// This table is only used to store a patients previous IHI, we currently do not do anything with the
    /// data within code
    /// </summary>
    [KnownType(typeof(PatientMasterIhiHistory))]
    [Serializable]
    [DataContract]
    public class PatientMasterIhiHistory : BaseSchema
    {
        /// <summary>
        /// Specifies which HPO network this organisation belongs to.
        /// </summary>
        /// <value>
        /// Health Provider Organisation Network Id
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int HealthProviderOrganisationNetworkId { get; set; }

        /// <summary>
        /// Gets or sets the ihi (Historic).
        /// </summary>
        /// <value>
        /// The ihi.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string Ihi { get; set; }

        /// <summary>
        /// Gets or sets the IHI lookup audit ID.
        /// </summary>
        /// <value>
        /// The ihi lookup audit ID.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.AutoGeneratedKey)]
        public int? IhiHistoryId
        {
            get
            {
                return base.Id;
            }
            set
            {
                base.Id = value;
            }
        }

        /// <summary>
        /// Gets or sets the ihi record status id.
        /// </summary>
        /// <value>
        /// The ihi record status id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int IhiRecordStatusId { get; set; }

        /// <summary>
        /// Gets or sets the ihi status.
        /// </summary>
        /// <value>
        /// The ihi status.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int IhiStatusId { get; set; }

        /// <summary>
        /// Gets or sets the patient master ID.
        /// </summary>
        /// <value>
        /// The patient master ID.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int PatientMasterID { get; set; }
    }
}