﻿using System.Collections.Generic;
using HIPS.CommonSchemas.Hi;
using HIPS.PcehrDataStore.DataAccess;

namespace HIPS.PcehrHiBusinessLogic.Hi
{
    public class HiReference
    {
        #region Private Members

        #endregion Private Members

        #region Properties

        #endregion Properties

        #region Methods

        /// <summary>
        /// Gets the street suffix types.
        /// </summary>
        /// <returns></returns>
        public List<HiStreetSuffixType> GetHiStreetSuffixTypes()
        {
            StreetSuffixTypeCodeDl data = new StreetSuffixTypeCodeDl();
            List<HiStreetSuffixType> list = data.GetAll<HiStreetSuffixType>(HIPS.CommonSchemas.CodeSystemCode.HI_ReferenceCodes.ToString());
            return list;
        }

        /// <summary>
        /// Gets the street types.
        /// </summary>
        /// <returns></returns>
        public List<HiStreetType> GetHiStreetTypes()
        {
            StreetTypeCodeDl data = new StreetTypeCodeDl();
            List<HiStreetType> list = data.GetAll<HiStreetType>(HIPS.CommonSchemas.CodeSystemCode.HI_ReferenceCodes.ToString());
            return list;
        }

        /// <summary>
        /// Gets the UnitType List.
        /// </summary>
        /// <returns></returns>
        public List<HiUnitType> GetHiUnitTypes()
        {
            UnitTypeCodeDl data = new UnitTypeCodeDl();
            List<HiUnitType> list = data.GetAll<HiUnitType>(HIPS.CommonSchemas.CodeSystemCode.HI_ReferenceCodes.ToString());
            return list;
        }

        /// <summary>
        /// Gets the LevelType List.
        /// </summary>
        /// <returns></returns>
        public List<HiLevelType> GetHiLevelTypes()
        {
            LevelTypeCodeDl data = new LevelTypeCodeDl();
            List<HiLevelType> list = data.GetAll<HiLevelType>(HIPS.CommonSchemas.CodeSystemCode.HI_ReferenceCodes.ToString());
            return list;
        }

        /// <summary>
        /// Gets the PostalDeliveryType List.
        /// </summary>
        /// <returns></returns>
        public List<HiPostalDeliveryType> GetHiPostalDeliveryTypes()
        {
            PostalDeliveryTypeCodeDl data = new PostalDeliveryTypeCodeDl();
            List<HiPostalDeliveryType> list = data.GetAll<HiPostalDeliveryType>(HIPS.CommonSchemas.CodeSystemCode.HI_ReferenceCodes.ToString());
            return list;
        }

        /// <summary>
        /// Gets the State List.
        /// </summary>
        /// <returns></returns>
        public List<HiState> GetHiStates()
        {
            StateCodeDl data = new StateCodeDl();
            List<HiState> list = data.GetAll<HiState>(HIPS.CommonSchemas.CodeSystemCode.HI_ReferenceCodes.ToString());
            return list;
        }

        /// <summary>
        /// Gets the Country List.
        /// </summary>
        /// <returns></returns>
        public List<HiCountry> GetHiCountries()
        {
            CountryCodeDl data = new CountryCodeDl();
            List<HiCountry> list = data.GetAll<HiCountry>(HIPS.CommonSchemas.CodeSystemCode.HI_ReferenceCodes.ToString());
            return list;
        }

        /// <summary>
        /// Gets the Sex List.
        /// </summary>
        /// <returns></returns>
        public List<HiSex> GetHiSexes()
        {
            SexCodeDl data = new SexCodeDl();
            List<HiSex> list = data.GetAll<HiSex>(HIPS.CommonSchemas.CodeSystemCode.HI_ReferenceCodes.ToString());
            return list;
        }

        #endregion Methods
    }
}