﻿using System;
using System.Runtime.Serialization;
using HIPS.CommonSchemas;

namespace HIPS.PcehrSchemas
{
    /// <summary>
    /// This object is used for the package response from the “Patient Registration” methods.
    /// </summary>
    [Serializable]
    [DataContract(Name = "PcehrRegistrationResponse")]
    public class PcehrRegistrationResponse
    {
        #region Private Members

        private HipsResponse hipsResponse = new HipsResponse(HipsResponseIndicator.SystemError, null);
        private string ivcCode = string.Empty;
        private DateTime ivcExpiryDate = DateTime.MinValue;
        private int patientMasterId;

        #endregion Private Members

        #region Properties

        /// <summary>
        /// Gets or sets the HipsResponse.
        /// Common Response Object.
        /// </summary>
        /// <value>
        /// The hipsResponse
        /// </value>
        [DataMember]
        public HipsResponse HipsResponse
        {
            get { return hipsResponse; }
            set { hipsResponse = value; }
        }

        /// <summary>
        /// Gets or sets the ivc code.
        /// </summary>
        /// <value>
        /// The ivc code.
        /// </value>
        [DataMember]
        public string IvcCode
        {
            get { return ivcCode; }
            set { ivcCode = value; }
        }

        /// <summary>
        /// Gets or sets the ivc expiry date.
        /// </summary>
        /// <value>
        /// The ivc expiry date.
        /// </value>
        [DataMember]
        public DateTime IvcExpiryDate
        {
            get { return ivcExpiryDate; }
            set { ivcExpiryDate = value; }
        }

        /// <summary>
        /// Gets or sets the HIPS internal identifier for the person record.
        /// Use this number as the patientMasterId parameter to the appropriate
        /// Reregister method if the registration was unsuccessful and the user
        /// wishes to modify some information and try again.
        /// </summary>
        [DataMember]
        public int PatientMasterId
        {
            get { return patientMasterId; }
            set { patientMasterId = value; }
        }

        #endregion Properties
    }
}