﻿using System;
using System.Runtime.Serialization;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace HIPS.PcehrSchemas
{
    /// <summary>
    /// This class defines the details of the response channel that
    /// the applicant wishes to use to receive their IVC.
    /// </summary>
    [KnownType(typeof(RegistrationCorrespondenceChannel))]
    [Serializable]
    [DataContract]
    public class RegistrationCorrespondenceChannel
    {
        #region Properties

        /// <summary>
        /// Gets or sets the channel.
        /// </summary>
        /// <value>
        /// The channel.
        /// </value>
        [DataMember]
        public IvcCorrespondenceChannel Channel
        {
            get;
            set;
        }

        /// <summary>
        /// Gets or sets the email.
        /// </summary>
        /// <value>
        /// The email.
        /// </value>
        [DataMember]
        public string email
        {
            get;
            set;
        }

        /// <summary>
        /// Gets or sets the phone number.
        /// </summary>
        /// <value>
        /// The phone number.
        /// </value>
        [DataMember]
        public string phoneNumber
        {
            get;
            set;
        }

        #endregion Properties
    }
}