﻿using System.Collections.Generic;
using System.ServiceModel;
using HIPS.CommonSchemas.Hi;

namespace HIPS.Reference.ServiceContracts
{
    /// <summary>
    /// Service interface for the Healthcare Identifier Reference Service.
    /// Contains methods used to retrieve reference data from the Healthcare Identifier Reference Service
    /// </summary>
    [WCFExtras.Wsdl.Documentation.XmlComments]
    [ServiceContract(Namespace = "http://schemas.HIPS/Services/2012/01", Name = "IHiReferenceService")]
    public interface IHiReferenceService
    {
        /// <summary>
        /// Gets the Country List from the Healthcare Identifier Reference Service
        /// </summary>
        /// <returns>List of countries.</returns>
        [OperationContract]
        List<HiCountry> GetHiCountries();

        /// <summary>
        /// Gets the LevelType List from the Healthcare Identifier Reference Service
        /// </summary>
        /// <returns>List of level types.</returns>
        [OperationContract]
        List<HiLevelType> GetHiLevelTypes();

        /// <summary>
        /// Gets the PostalDeliveryType List from the Healthcare Identifier Reference Service
        /// </summary>
        /// <returns>List of postal delivery types.</returns>
        [OperationContract]
        List<HiPostalDeliveryType> GetHiPostalDeliveryTypes();

        /// <summary>
        /// Gets the Sex List from the Healthcare Identifier Reference Service
        /// </summary>
        /// <returns>List of sex codes.</returns>
        [OperationContract]
        List<HiSex> GetHiSexes();

        /// <summary>
        /// Gets the State List from the Healthcare Identifier Reference Service
        /// </summary>
        /// <returns>List of states.</returns>
        [OperationContract]
        List<HiState> GetHiStates();

        /// <summary>
        /// Gets the StreetSuffixTypes List from the Healthcare Identifier Reference Service
        /// </summary>
        /// <returns>List of street suffixes.</returns>
        [OperationContract]
        List<HiStreetSuffixType> GetHiStreetSuffixTypes();

        /// <summary>
        /// Gets the StreetType List from the Healthcare Identifier Reference Service
        /// </summary>
        /// <returns>List of street types.</returns>
        [OperationContract]
        List<HiStreetType> GetHiStreetTypes();

        /// <summary>
        /// Gets the UnitType List from the Healthcare Identifier Reference Service
        /// </summary>
        /// <returns>List of unit types.</returns>
        [OperationContract]
        List<HiUnitType> GetHiUnitTypes();
    }
}